#ifndef TIMESHEET_H_INCLUDED
#define TIMESHEET_H_INCLUDED

/* Used to find the PalmPilot memo pad database */
#define MemoPadAppID  ('memo')
#define MemoPadDBType ('DATA')

/* The minimum PalmOS version this app will run under, which is PalmOS 2.0 */
#define TSRomVersion (0x02003000)
/* The application database ID */
#define TSAppID     ('TiSh')
/* The application database type */
#define TSDBType    ('data')
/* The summary database type (used to build temporary databases that hold summary view information) */
#define TSSummaryDBType ('datT')
/* The application database name */
#define TSDBName    ("TimesheetDB")
/* The temporary summary database name */
#define TSSummaryDBName ("TSSummary")
/* The version number of the database (more or less corresponds to the application version number). */
#define TSDBMajorVersion (1)
#define TSDBMinorVersion (5)
#define TSDBVersion ((TSDBMajorVersion << 8) | (TSDBMinorVersion))

/* The maximum number of client, projects or task entries allowed,
 * including the the 2 automatic entries of 'none' and 'Edit...' */
#define TSMaxCatEntries     (102)
/* The length of each client, project or task list entry. */
#define TSMaxCatEntryLen    (17 + 1)
/* The number of default clients (including the automatic entries) */
#define TSNumDefaultClients  (4)
/* The number of default projects (including the automatic entries) */
#define TSNumDefaultProjects (5)
/* The number of default tasks (including the automatic entries) */
#define TSNumDefaultTasks    (7)

/* The database record index of the first actual day record in the timesheet database.
 * All records prior to this record hold application resource information. */
#define TSFirstDayRecIdx     (4)

/* The maximum number of timesheet entries allowed in a single day. This is the absolute maximum under the present
 * database structure.*/
#define TSMaxEntriesPerDay   (125)
/* The number of rows in the main table */
#define TSMainFormTableRows (9)
/* The number of rows in the summary tables */
#define TSSummaryFormTableRows (9)
/* The number of columns in the main table */
#define TSMainFormTableCols  (4)

/******************************************************************
 * Forward declarations for functions and data types.
 ******************************************************************/

/******************************************************************
 * First 2 bits of record attribute is used to mark the record type
 * within the Timesheet database.
 ******************************************************************/
#define TSRecAttrMask    (0x03)
/* Database record attribute used to identify special records in the database */
#define TSSpecialRecAttr (0x00)
/* Database record attribute used to identify day header records in the database */
#define TSDayRecAttr     (0x01)
/* Database record attribute used to identify day entry records in the database */
#define TSEntryRecAttr   (0x02)
/* Database record attribute mask used to identify charged entry records in the database */
#define TSEntryChargedAttr (0x08)

/******************************************************************
 * Struct used to hold (and store) application internal data over
 * multiple app executions.
 ******************************************************************/
typedef struct
  {
    /* The number of entries in each category (clients/projects/tasks). */
    Byte numCatEntries[3];
    /* Preference related */
    Byte newCatEntryIdx[3];     /* saved default category indexes for new entries (for Auto Categories pref) */    
    Byte prefFlags;             /* pref flags */
    Byte newCatHours;           /* saved default category hours/minutes for new entries (for Auto Duration pref) */
    /* Following this point in the record, one or more TSEntryTimerType structures may appear,
     * one for each running timer (v1.5 currently only supports a single timer) */
  }
TSAppPrefType;

/******************************************************************
 * Struct used to hold (and store) entry timers at the end of the preferences
 * record. Hmmm, they probably shouldn't really go there (are they preferences?)
 * but doing it this way saves having to alter the database format by inserting new
 * records.
 ******************************************************************/
typedef struct
{
    /* Entry timer related */
    UInt recIdx;        /* index of entry record we're timing. 0 if timing new entry. */
    ULong secs;         /* entry seconds since 1970. > 0 if we're actually timing. */
}
TSEntryTimerType;

/* Preference flag masks (1 bit per flag) */
#define TSPrefShortDateFlag     (0x01)  /* use system short date format instead of long */
#define TSPrefUlineClientFlag   (0x02)  /* underline chargeable clients */
#define TSPrefAutoCatsFlag      (0x04)  /* use auto categories for new entries */
#define TSPrefAutoDurFlag       (0x08)  /* use auto durations for new entries */
#define TSPrefDefaultChargeFlag (0x10)  /* new entries are chargeable by default */
#define TSPrefAlwaysTimeFlag    (0x20)  /* when timing entries, keep timing when OK tapped */
#define TSPrefChargeTotalsFlag  (0x40)  /* display chargeable totals on day and week forms */
#define TSPrefUNUSED2Flag       (0x80)  /* CURRENTLY UNUSED */
/* Default prefs for new database */
#define TSPrefDefaultFlags      (TSPrefUlineClientFlag)

/******************************************************************
 * Struct used to hold Client, Project and Task category lists.
 ******************************************************************/
typedef struct
  {
    /* The translation table for the entries */
    Byte transTable[TSMaxCatEntries];
    /* The text of the actual entries, will always contain at least two automatic entries, 'none' and 'Edit...'
     * Note *all* entries appear in this struct, but the actual record will only containing the existing
     * entries in low indexes. */
    Char cats[TSMaxCatEntries][TSMaxCatEntryLen];
  }
TSCatRecType;

/******************************************************************
 * Struct used to hold (and store) day records.
 ******************************************************************/
typedef struct
  {
    /* Number of entries in this day */
    Byte numEntries;
    /* Date this day record relates to. */
    DateType dayDate;
  }
TSDayRecType;

/******************************************************************
 * Struct used to hold (and store) entry records.
 ******************************************************************/
typedef struct
  {
    /* Which client does this record relate to. */
    Byte clientIdx;
    /* Which project does this record relate to. */
    Byte projectIdx;
    /* Which task does this record relate to. */
    Byte taskIdx;
    /* How many hours/minutes does this record use. */
    Byte hours;
    /* Entry number of this entry within the current day (i.e. first entry in day = 1). Used during binary searching
     * of Timesheet database. Must be updated each time a record is DELETED from day. */
    Byte entryNum;
    /* Filler for future possible expansion */
    Byte filler;
    /* Note there's no 'chargeable' variable. This because 'chargeable' is indicated by setting the highest bit in the
     * record category (part of attributes) on. */
    /* Following the end of the structure is the first character of descriptive text for to this record. */
  }
TSEntryRecType;

/******************************************************************
 * Struct used to hold hour/minute durations
 ******************************************************************/
typedef struct
  {
    Int hours;
    Byte mins;
  }
TSDurationRecType;

/******************************************************************
 * Struct used to hold (and store) weekly/monthly summary records.
 ******************************************************************/
typedef struct
  {
    /* Translated client, project, task indexes for this record. */
    Byte catIdx[3];
    /* Total hours/minutes for this Client/Project/Task combination.
     * Minutes are stored in high 4 bits, remaining 12 bits hours. */
    UInt totalDuration;
  }
TSSummaryRecType;

/******************************************************************
 * Struct used to hold (and store) weekly/monthly summary total duration record.
 ******************************************************************/
typedef struct
  {
    UInt totalHours;
    Byte totalMins;
        UInt totalChargeableHours;
        Byte totalChargeableMins;
  }
TSSummaryTotalRecType;

/******************************************************************
 * Application Macros
 ******************************************************************/

/**
 * Returns true if the specified character is whitespace
 */
#define ISSPACE(c) (((c) == ' ') || ((c) == '\t') || ((c) == '\n'))

#endif /*** TIMESHEET_H_INCLUDED ***/

/*** End of file ***/
