#ifndef GLOBALS_H_INCLUDED
#define GLOBALS_H_INCLUDED

/******************************************************************
 * Application global variables
 ******************************************************************/
#include <PalmCompatibility.h>
#include <PalmOS.h>

/* Application copy of the relevant system preferences. */
extern DateFormatType TSSysDateFormat;
extern DateFormatType TSSysLongDateFormat;
extern Byte TSSysWeekStartDay;

/* Application copy of the preferences stored in the database record 0. */
extern TSAppPrefType TSAppPrefs;

/* Single global entry timer is supported */
extern TSEntryTimerType TSEntryTimer;

/* The presently open timesheet database. */
extern DmOpenRef TSDatabase;

/* True if a record exists for the present day. */
extern Boolean TSPresentDayRecExists;

/* The day record index for the present day (if TSPresentDayRecExists = true),
 * otherwise the record index to insert a day record for the present day.
 */
extern UInt TSPresentDayRecIdx;

/******************************************************************
 * Globals relating to the GUI and the presently visible form.
 ******************************************************************/
/* Used to pass information to the Details form. Set this to the database record idx of the entry
 * you're editing, or to 0 if you're attempting to create a *new* entry. */
extern UInt TSEditEntryIdx;

/* The database record number of the list to edit in the category Edit dialog */
extern Byte TSEditCatRecIdx;

/* The category entry number of the category beging edited in the category entry Edit dialog, or 0 if you're
 * creating a new category. */
extern Byte TSEditCatEntryIdx;

/* The present logical day button that is selected on the main form (ie. 0 to 6, not the actual button ID) */
extern Byte TSSelectedDayButton;

/* The day entry that presently appears at the top of the table in the current form (Main, Weekly or Monthly) */
extern SWord TSTableTopEntry;

/* The date of the present day being displayed. */
extern DateType TSPresentDayDate;

/* The adjusted summary date (based on TSPresentDayDate) being displayed. */
extern DateType TSPresentSummaryDate;

#endif /*** GLOBALS_H_INCLUDED ***/

/*** End of file ***/
