#ifndef DATABASE_H_INCLUDED
#define DATABASE_H_INCLUDED

/* Application summary related functions. */
Int _SummaryFindCompareFunc(VoidPtr rec1Ptr, VoidPtr rec2Ptr, Int other_ignored);
Boolean BuildSummaryDatabase(DateType * startDate, DateType * endDate);
Int GetNumSummaryRecords(void);

/* Application database related functions. */
Boolean DateRangeToDatabaseIndex(DateType * startDate, DateType * endDate,
                                        UInt * startRecIdx, UInt * endRecIdx);
void EraseDatabaseRange(DateType * startDate, DateType * endDate);
Int _DayFindCompareFunc(VoidPtr rec1Ptr, VoidPtr rec2Ptr, Int other_ignored,
                               SortRecordInfoPtr rec1InfoPtr, SortRecordInfoPtr rec2InfoPtr, VoidHand appInfoH);
Boolean FindEarliestDayRec();
Boolean FindLatestDayRec();
void FindDayRec(DateType * dayDate, UInt * presentDayRecIdx, Boolean * presentDayRecExists);
Err InitDatabase(void);
Err OpenDatabase(void);
Boolean ReorgDatabase(TSCatRecType * catPtr, Int catRecIdx);
UInt FindPrevDayRecIdx(DmOpenRef db, UInt presentRecIdx);
Err OpenPreferences(void);
void ClosePreferences(void);

Boolean FindInCategory(DmOpenRef db, UInt catRec, UInt entryCatIdx, FindParamsPtr findParams);
void FindInDatabase(FindParamsPtr findParams);

Err UpgradeDatabase(UInt cardNo, LocalID dbID, UInt fromDBVersion);
Err VersionCheckDatabase(void);

#endif /*** DATABASE_H_INCLUDED ***/

/*** End of file ***/
